#ifndef MYFILE_HDLINUXIO
#define MYFILE_HDLINUXIO

#include <cstdlib>
#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include <unistd.h>
#include <termios.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <time.h>
#include "halcyon.h"

using namespace std;

class LinuxPort {
		 bool isOpen, verbose;
		 int portfd, lastread, cflag;
		 float autodiscoverwait, defautodiscwait;
		 unsigned int testparm[11];
		 unsigned long naptime;
		 long BAUD;
		 long DATABITS;
		 long STOPBITS;
		 long PARITYON;
		 long PARITY;
		 string serialdevice;
		 string testdata;
		 vector<string> devlist;
		 vector<string> devtype;
		 struct termios options, oldios;
		 ConfigFile* mainConfig;

	public:
		LinuxPort();
		void setconfig(ConfigFile*);
		void setverbose(bool);
		bool testport(string);
		bool findhdradio();
		void setportattr(int);
		bool openport();
		void closeport();
		void setserialport(string);
		string getserialport();
		void hdsendbyte(char);
		void hdsendbytes(char*);
		char* hdreadbytes(int);
		char* hdreadbyte();
		int hdlastreadleangth();
		void addsearchdevice(string);
		void addsearchtype(string);
		void toggledtr(bool);
		void printdtr();
		void printdtr(string);
		bool getdtr();
		void hanguponexit(bool);

	protected:
		void chout(unsigned char);

	private:

};



#endif
