package com.hal.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.util.HashMap;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

import com.hal.conf.GeneralConfig;

public class GUIUtils {
	
	boolean texterIsActive = false;
	
	JFrame parentFrame;
	JTextArea jTexter = null;
	
//	Border raisedBorder = null;
//	Border loweredBorder = null;
//	EtchedBorder doubleEtched = null;
//	TitledBorder raisedTitle = null;
//	TitledBorder loweredTitle = null;
	
	HashMap textWindow = new HashMap(), helpWindow = new HashMap();
	
	GeneralConfig myConfig = null;
	
	public HalProgressMonitor tokenMonitor = null;
	
	public GUIUtils(GeneralConfig systemConfig) {
		myConfig = systemConfig;
//        raisedetched = BorderFactory.createEtchedBorder(EtchedBorder.RAISED);
//        loweredetched = BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
//        
//        raisedBorder = BorderFactory.createRaisedBevelBorder();
//        loweredBorder = BorderFactory.createLoweredBevelBorder();
		return;
	}
	
	public void addLoweredBorder(JComponent jComp) {
		Border lb = BorderFactory.createLoweredBevelBorder();
		jComp.setBorder(lb);
		return;
	}
	
	public void addRaisedBorder(JComponent jComp) {
		Border rb = BorderFactory.createRaisedBevelBorder();
		jComp.setBorder(rb);
		return;
	}
	
	public void addCompoundBorder(JComponent jComp) {
		Border lb = BorderFactory.createLoweredBevelBorder();
		Border rb = BorderFactory.createRaisedBevelBorder();
		Border cb = BorderFactory.createCompoundBorder(rb, lb);
		jComp.setBorder(cb);
		return;
	}
	
	public void addLoweredTitleBorder(JComponent jComp, String borderTitle) {
		Border lb = BorderFactory.createLoweredBevelBorder();
		TitledBorder tb = BorderFactory.createTitledBorder(lb, borderTitle);
		jComp.setBorder(tb);
		return;
	}
	
	public void addRaisedTitleBorder(JComponent jComp, String borderTitle) {
		Border rb = BorderFactory.createRaisedBevelBorder();
		TitledBorder tb = BorderFactory.createTitledBorder(rb, borderTitle);
		jComp.setBorder(tb);
		return;
	}
	
	public void addCompoundTitledBorder(JComponent jComp, String borderTitle) {
		Border lb = BorderFactory.createLoweredBevelBorder();
		Border rb = BorderFactory.createRaisedBevelBorder();
		Border cb = BorderFactory.createCompoundBorder(rb, lb);
		TitledBorder tb = BorderFactory.createTitledBorder(cb, borderTitle);
		jComp.setBorder(tb);
		return;
	}
	
	public void setParentFrame(JFrame parentFrame) {
		this.parentFrame = parentFrame;
		return;
	}
	
	public void makeTexter() {
		
		texterIsActive = true;
		return;
	}
	
	public void closeTexter() {

		texterIsActive = false;
		return;
	}
	
	public boolean isActive() {	
		return texterIsActive;
	}
	
	public void clearTexter() {
		
		return;
	}
	
	public void setTexterContent(String textContent) {
		
		return;
	}
	
	public void appendTexterContent(String textContent) {
		
		return;
	}
	
	public void makeHelpWindow(String helpInfo) {
		
		return;
	}
	
	public void closeHelpWindow(String helpInfo) {
		
		return;
	}
	
	public void makeTextWindow(String windowTitle, String windowText) {
		
		return;
	}
	
	public void closeTextWindow(String windowTitle) {
		
		return;
	}
	
	/**
	 * Do a quick information message for the user.
	 * @param sPrompt message to show.
	 */
	public void showInfoDialog(String sPrompt) {
		JOptionPane.showMessageDialog(parentFrame, sPrompt, "Important Information:", JOptionPane.PLAIN_MESSAGE);
		if (tokenMonitor != null)
			tokenMonitor.moveAllToFront();
		return;
	}

	/**
	 * Get a directory name using a file chooser.
	 * @param sPrompt prompt for the user
	 * @return full file path.
	 */
	public String showDirectoryDialog(String sPrompt) {
		String newDirectory = "";
		newDirectory = showFileDialog(sPrompt, true);
		if (tokenMonitor != null)
			tokenMonitor.moveAllToFront();
		return newDirectory;
	}
	
	/**
	 * Get a file using a file chooser.
	 * @param sPrompt prompt for the user
	 * @return full file path.
	 */
	public String showFileDialog(String sPrompt) {
		String newFile = "";
		newFile = showFileDialog(sPrompt, false);
		if (tokenMonitor != null)
			tokenMonitor.moveAllToFront();
		return newFile;
	}
	
	/**
	 * Used by getFile and getDir to let the user pick a file or dir.  We handle
	 * both quickly and easily.
	 * @param sPrompt Prompt to use to ask for file or directory
	 * @param getDir true if we're getting a dir, false for file
	 * @return full file path
	 */
	private String showFileDialog(String sPrompt, boolean getDir) {
		int iCode;
		String newFile = "";
		JFileChooser fileChooser = new JFileChooser();
		if (getDir) {
			fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		} else {
			fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		}
		iCode = fileChooser.showDialog(parentFrame, sPrompt);
		if (iCode == JFileChooser.APPROVE_OPTION) {
			File tFile = fileChooser.getSelectedFile();
			newFile = tFile.getPath();
		}
		if (tokenMonitor != null)
			tokenMonitor.moveAllToFront();
		return newFile;
	}
	
	/**
	 * Show a dialog and get a text ansewr back.
	 * @param sPrompt prompt for the user
	 * @return user's response
	 */
	public String showTextDialog(String sPrompt) {
		String sText = "";
		sText = showTextDialog(sPrompt, "");
		if (tokenMonitor != null)
			tokenMonitor.moveAllToFront();
		return sText;
	}
	
	/**
	 * Get text info from the user.  Prompt with a defalt text.
	 * @param sPrompt question or message to show the user
	 * @param sDefault default answer
	 * @return input text
	 */
	public String showTextDialog(String sPrompt, String sDefault) {
		String sText = "";
		sText = (String) JOptionPane.showInputDialog(parentFrame, sPrompt, "Reply Needed:", JOptionPane.PLAIN_MESSAGE, null, null, sDefault);
		if (tokenMonitor != null)
			tokenMonitor.moveAllToFront();
		return sText;
	}
	
	/**
	 * Show a dialog and get a Yes or No answer.  True is yes.
	 * @param sMessage message to prompt the user with
	 * @return true if the answer was yes
	 */
	public boolean showYesNoDialog(String sMessage) {
		boolean bResult = true;
		int iAnswer;
		iAnswer = JOptionPane.showConfirmDialog(parentFrame, sMessage, "Reply Needed:", JOptionPane.YES_NO_OPTION);
		if (iAnswer > 0)
			bResult = false;
		if (tokenMonitor != null)
			tokenMonitor.moveAllToFront();
		return bResult;
	}

	/**
	 * Center a window on the screen.
	 * @param fWindow the window to center
	 */
	public static void centerWindow(JFrame fWindow) {
		Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension dFrame = fWindow.getSize();
		if (dFrame.height > dScreen.height) {dFrame.height = dScreen.height;}
		if (dFrame.width > dScreen.width) {dFrame.width = dScreen.width;}
		fWindow.setLocation((dScreen.width - dFrame.width) / 2,
				(dScreen.height - dFrame.height) / 2);
		return;
	}
	
	/**
	 * Center one window over top of another window.
	 * @param currentWindow the existing window
	 * @param newWindow the window to center over top of the other one.
	 */
	public static void centerWindowOnWindow(JFrame currentWindow, JFrame newWindow) {
		Point pCurrent = currentWindow.getLocation();
		Dimension dCurrent = currentWindow.getSize();
		Dimension dNew = newWindow.getSize();
		int xPos = pCurrent.x;
		int yPos = pCurrent.y;
		int xOffset = (dCurrent.width - dNew.width) / 2;
		int yOffset = (dCurrent.height - dNew.height) / 2;
		xPos = xPos + xOffset;
		yPos = yPos + yOffset;
		newWindow.setLocation(xPos, yPos);
		return;
	}

	/**
	 * Set the size of a Swing component by specifying the preferred, minimum,
	 * and maximum sizes.
	 * @param jc the component to size
	 * @param x width in pixels
	 * @param y height in pixels
	 */
	public static void setSize(JComponent jc, int x, int y) {
		setSize(jc, new Dimension(x, y));
//		jc.setPreferredSize(new Dimension(x, y));
//		jc.setMinimumSize(new Dimension(x, y));
//		jc.setMaximumSize(new Dimension(x, y));
		return;
	}

	/**
	 * Set the size of a Swing component by specifying the preferred, minimum,
	 * and maximum sizes to all match the specified dimension. 
	 * @param jc the component to size
	 * @param d the dimensions to size it to.
	 */
	public static void setSize(JComponent jc, Dimension d) {
		jc.setPreferredSize(d);
		jc.setMinimumSize(d);
		jc.setMaximumSize(d);
		return;
	}

}
