package com.hal.gui;
import java.awt.Component;
import java.awt.Container;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingConstants;

public class SplashPanel extends JFrame {

	private static final long serialVersionUID = 1L;
	final int D_WIDTH = 301;
	final int D_HEIGHT = 76;
	JLabel lStatus = new JLabel("Loading Program...");

//	public SplashPanel (ImagePanel iPanel) {
	public SplashPanel (String programName) {
		Container contentPane = getContentPane();
		setTitle(programName);
		lStatus.setText("Loading " + programName + "...");
		setSize(D_WIDTH, D_HEIGHT);
//		lStatus.setPreferredSize(new Dimension(296, 71));
//		lStatus.setMaximumSize(new Dimension(296, 71));
//		lStatus.setHorizontalAlignment(lStatus.CENTER);
		lStatus.setHorizontalAlignment(SwingConstants.CENTER);
		lStatus.setAlignmentX(Component.CENTER_ALIGNMENT);
		contentPane.add(lStatus);
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		GUIUtils.centerWindow(this);
		return;
	}

	public void setStatus(String sStatus) {
		lStatus.setText(sStatus);
		return;
	}
}