package com.hal.oldtimeradio;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import com.hal.conf.GeneralConfig;
import com.hal.gui.GUIUtils;

public class ErrorList implements ActionListener {

	private JFrame jFrame = null;  //  @jve:decl-index=0:visual-constraint="177,121"
	private JPanel jContentPane = null;
	private JPanel jPanel = null;
	private JPanel jPanel1 = null;
	private JButton jbClose = null;
	private JScrollPane jScrollPane = null;
	private JTable jtErrors = null;
	
	boolean isVisible = false, firstOpen = true;
	String[] allErrors;
	String[] colNames = new String[] {"Show Title", "Episode Title", "Show Directory", "Episode File", "Error"};
	int[] colWidth = new int[] {40, 40, 30, 40, 100};

	DefaultTableModel dataTable = null;
	
	JFrame parentFrame;
	
	GeneralConfig myConfig;
	OTRDownload otrControl;
	
	/**
	 * YA dull, boring constructor.  Just initialize variables and setup the GUI.  Nothing to see here.  Move along.
	 * @param programConfig
	 */
	public ErrorList(GeneralConfig programConfig) {
		myConfig = programConfig;
		otrControl = (OTRDownload) myConfig.getObject("otrcontrol");
		parentFrame = otrControl.jFrame;
		guiSetup();
	}
	
	/**
	 * Reset the count to 0 errors.  This lets us start a new list.
	 */
	public void reset() {
		dataTable.setRowCount(0);
		return;
	}
	
	/**
	 * Add a full array of errors to the table.  Each line must be tab separated and
	 * the fields have to match the multi-String-parameter version of addItem().
	 * @param newErrors the array of errors to add.
	 */
	public void addItems(String[] newErrors) {
		int x;
		for (x = 0; x < newErrors.length; x++) {
			addItem(newErrors[x]);
		}
		return;
	}
	
	/**
	 * Add one error as a line of tab separated values.  The values must match the other version
	 * of this overloaded method.
	 * @param errorLine
	 */
	public void addItem(String errorLine) {
		String[] errorItems = errorLine.split("\t");
		if (errorItems.length < 5)
			return;
		addItem(errorItems[0], errorItems[1], errorItems[2], errorItems[3], errorItems[4]);
		return;
	}
	
	public void addItem(String showName, String episodeTitle, String showDir, String episodeFile, String errorMsg) {
		dataTable.addRow(new String[] {showName, episodeTitle, showDir, episodeFile, errorMsg});
		System.out.println("Error, Show: " + showName + ", Episode title: " + episodeTitle + 
				", Show directory: " + showDir + ", Episode file: " + episodeFile + ", Error: " + errorMsg);
		return;
	}
	
	/**
	 * Make the window visible or invisible.  The first time it opens, it's centered on the
	 * main window, after that it opens where it was the last time it was open.
	 * @param isVisible true to make it visible
	 */
	public void setVisible(boolean isVisible) {
		this.isVisible = isVisible;
		if (firstOpen) {
			parentFrame = otrControl.jFrame;
			GUIUtils.centerWindowOnWindow(parentFrame, jFrame);
		}
		if (isVisible)
			otrControl.deactivate();
		else
			otrControl.activate();
		jFrame.setVisible(isVisible);
		firstOpen = false;
		return;
	}
	
	/**
	 * Event dispatching routine.
	 */
	public void actionPerformed(ActionEvent aEvent) {
		Object sourceControl = aEvent.getSource();
		if (sourceControl == jbClose) {
			setVisible(false);
		}
		return;
	}
	
	/**
	 * Ugly part of GUI setup.
	 */
	private void guiSetup() {
		int x;
		TableColumnModel tcModel;
		TableColumn thisColumn;
		getJFrame();
		jScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		jScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		jtErrors.setColumnSelectionAllowed(false);
		jtErrors.setRowSelectionAllowed(true);
		jtErrors.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		jtErrors.setShowGrid(true);
		jtErrors.getTableHeader().setBackground(Color.yellow);
//		jtErrors.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		dataTable = (DefaultTableModel) jtErrors.getModel();
		tcModel = jtErrors.getColumnModel();
		for (x = 0; x < colNames.length; x++) {
			dataTable.addColumn(colNames[x]);
			thisColumn = tcModel.getColumn(x);
			thisColumn.setPreferredWidth(colWidth[x]);
		}
		jbClose.addActionListener(this);
	}

//	=============================================================================
//	Beyond here, there be dragons
//	=============================================================================
		
	/**
	 * This method initializes jFrame	
	 * 	
	 * @return javax.swing.JFrame	
	 */
	private JFrame getJFrame() {
		if (jFrame == null) {
			jFrame = new JFrame();
			jFrame.setSize(new Dimension(803, 240));
			jFrame.setTitle("Old Time Radio Show Downloader: Reported Sownload Errors");
			jFrame.setContentPane(getJContentPane());
		}
		return jFrame;
	}

	/**
	 * This method initializes jContentPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BoxLayout(getJContentPane(), BoxLayout.Y_AXIS));
			jContentPane.add(getJPanel(), null);
			jContentPane.add(getJPanel1(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.weighty = 1.0;
			gridBagConstraints1.gridx = 0;
			jPanel = new JPanel();
			jPanel.setLayout(new GridBagLayout());
			jPanel.add(getJScrollPane(), gridBagConstraints1);
		}
		return jPanel;
	}

	/**
	 * This method initializes jPanel1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel1() {
		if (jPanel1 == null) {
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 0;
			gridBagConstraints.gridy = 0;
			jPanel1 = new JPanel();
			jPanel1.setLayout(new GridBagLayout());
			jPanel1.add(getJButton(), gridBagConstraints);
		}
		return jPanel1;
	}

	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton() {
		if (jbClose == null) {
			jbClose = new JButton();
			jbClose.setText("Close Error List");
		}
		return jbClose;
	}

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setViewportView(getJTable());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jTable	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getJTable() {
		if (jtErrors == null) {
			jtErrors = new JTable();
		}
		return jtErrors;
	}

}
