package com.hal.oldtimeradio;

/**
 * Program: Old Time Radio Show Downloader
 * Copyright (C) 2007 by Hal Vaughan, hal@halblog.com  
 * Licensed under the General Public License (GPL) Version 2.0
 * See http://halblog.com for more information.
 * 
 * The site http://archive.org has, at my guess, over 10,000 episodes of old time radio
 * shows available for downloading.  This program is designed to make it easy to download these
 * shows more easily than using the web site.
 * 
 * Still to add:
 * - Help files
 * - Create a list of download files that spans shows
 *   - Edit or clear download list
 * - Pick and edit tags in downloaded files
 * - Play files
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.hal.conf.GeneralConfig;
import com.hal.gui.GUIUtils;
import com.hal.gui.HalProgressMonitor;
import com.hal.gui.HelpWindow;
import com.hal.networking.WebIO;
import com.hal.util.StringHashMap;

public class OTRDownload implements ActionListener, ListSelectionListener {

	public JFrame jFrame = null; // @jve:decl-index=0:visual-constraint="289,7"

	private JPanel jContentPane = null;
	private JScrollPane jScrollPane = null;
	private JScrollPane jScrollPane1 = null;
	private JScrollPane jScrollPane2 = null;
	private JPanel jPanel = null;
	private JPanel jPanel1 = null;
	private JPanel jPanel3 = null;
	private JPanel jPanel4 = null;
	private JPanel jPanel5 = null;
	private JPanel jPanel6 = null;
	private JLabel jEpisodeLabel = null;
	private JLabel jShowLabel = null;
	private JLabel jFormatLabel = null;
	private JLabel jFormatDataLabel = null;
	private JButton jbGetShows = null;
	private JButton jbGetEpisodes = null;
	private JButton jbDownload = null;
	private JButton jbHelp = null;
	private JButton jbQuit = null;
	private JButton jbNewDir = null;
	private JButton jbAddQueue = null;
	private JButton jbEditQueue = null;
	private JButton jbDLQueue = null;
	private JButton jbEditTags = null;
	private JButton jbTitles = null;
	private JList jlShows = null;
	private JList jlEpisodes = null;
	private JTextArea jtShowDesc = null;
	private JLabel jLabel1 = null;
	private JButton jbAbout = null;
	private JPanel jPanel2 = null;

	boolean isVisible = false, isAborted = false, fromQueue = false, firstAbout = true, firstHelp = true;

	public boolean isAutomated = false;

	int lastShow = -1, lastEpisode = -1, downloadDelay = 0, downloadRetry = 5;
	
	String helpFile = "0000-OTRMainHelp.html", aboutFile = "0000-OTRAbout.html";

	// OTRShell mainShell = null;
	GeneralConfig myConfig = null;

	GUIUtils guiUtils = null;
	HalProgressMonitor showMonitor = null;
	HalProgressMonitor fileMonitor = null;
	HelpWindow helpWindow = null, aboutWindow = null;

	WebIO webIO = new WebIO();
	ShowData allShows = null;
	EpisodeData allEps = null;
	WebOps webOps = null;
	DownloadQueue qDown;
	TagEditor tagEditor;
	TitleFilterControl titleControl;
	ErrorList errorList;

	String[] showTitles = null;
	String[] showDesc = null;
	String[] epTitles = null;
	String[] epFiles = null;
	StringHashMap episodeRef = null;

	private JPanel jPanel7 = null;

	private JPanel jPanel8 = null;

	private JButton jbGetEpisodes2 = null;



	/**
	 * Run from the command line.
	 * @param args arguments from the command line
	 */
	public static void main(String[] args) {
//		int x;
//		if (args != null) {
//			for (x = 0; x < args.length; x++) {
//				System.out.println("Arg " + x + ": " + args[x]);
//			}
//		}
		OTRDownload otrControl = new OTRDownload(args);
		otrControl.parseCommands();
		otrControl.setVisible(true);
		return;
	}

	/**
	 * Constructor to be used from a main() method from the command line. We do
	 * everything to create the download program.
	 * 
	 * @param commandArgs
	 *            the args passed from the command line
	 */
	public OTRDownload(String[] commandArgs) {
		myConfig = new GeneralConfig(commandArgs);
		downloadRetry = Integer.parseInt(myConfig.get("DownloadRetry"));
		downloadDelay = Integer.parseInt(myConfig.get("DownloadDelay"));
//		myConfig.listValues();
		guiSetup();
		allShows = new ShowData(myConfig);
		allEps = new EpisodeData(myConfig, allShows);
		allShows.loadShows();
		myConfig.putObject("allshows", allShows);
		myConfig.putObject("allepisodes", allEps);
		myConfig.putObject("otrcontrol", this);
		myConfig.putObject("otrcontrolframe", jFrame);
		tagEditor = new TagEditor(myConfig);
		tagEditor.parentFrame = jFrame;
		titleControl = new TitleFilterControl(myConfig);
		webOps = new WebOps(myConfig);
		qDown = new DownloadQueue(myConfig);
		qDown.parentFrame = jFrame;
		errorList = new ErrorList(myConfig);
		myConfig.putObject("errorlist", errorList);
		guiUtils = new GUIUtils(myConfig);
		guiUtils.setParentFrame(jFrame);
		loadShowList();
		// jbLoadEpisodes.setVisible(!autoLoad);
		loadEpisodeList();
		String sCheck = myConfig.get("DownloadDirectory");
		if (sCheck.equals("")) {
			String sPrompt = "The Old Time Radio Show Downloader needs a\n"
					+ "directory for storing the radio programs it\n"
					+ "downloads.  Since you have not specified a\n"
					+ "directory (this could be your first time\n"
					+ "running this program), you will now be asked\n"
					+ "to select a download directory.";
			guiUtils.showInfoDialog(sPrompt);
			setDLDir();
		}
		webOps = new WebOps(myConfig);
		webIO.appendData = true;
		showMonitor = new HalProgressMonitor(jFrame,
				"Downloading requested episode files.");
		fileMonitor = new HalProgressMonitor("Downloading file...");
		guiUtils.tokenMonitor = showMonitor;
		aboutWindow = new HelpWindow(600, 400, "Old Time Radio Show Downloader\n(c) 2008 Hal Vaughan\nhal@halblog.com", "Old Time Radio Show Downloader About");
		aboutFile = myConfig.get("OTRDirectory") + File.separator + aboutFile;
		aboutWindow.setFile(aboutFile);
		helpWindow = new HelpWindow(600, 400, "Help for main controls.", "Old Time Radio Show Downloader Help");
		helpFile = myConfig.get("OTRDirectory") + File.separator + helpFile;
		helpWindow.setFile(helpFile);
		return;
	}

	/**
	 * Nothing yet, but this is where settings will be set and commands will be
	 * commanded.
	 */
	public void parseCommands() {

		return;
	}

	/**
	 * Load the list of shows we have retrieved. If no shows, there's no list.
	 * If the episode list file for that show exists, then we put the name in
	 * blue to indicate it's been downloaded.
	 */
	public void loadShowList() {
		int x, iPoint;
		String[] loadTitles;
		iPoint = jlShows.getSelectedIndex();
		if (iPoint < 0) {
			iPoint = 0;
		}
		showTitles = allShows.listSortedTitles();
		loadTitles = new String[showTitles.length];
		showDesc = new String[showTitles.length];
		for (x = 0; x < showTitles.length; x++) {
			loadTitles[x] = showTitles[x];
			if (allShows.isDownloaded(showTitles[x])) {
				loadTitles[x] = "<html><font color=blue>" + showTitles[x]
						+ "</font></html>";
			}
			showDesc[x] = allShows.getDescription(showTitles[x]);
		}
		if (iPoint > showTitles.length) {
			iPoint = showTitles.length;
		}
		jlShows.setListData(loadTitles);
		jlShows.setSelectedIndex(iPoint);
		return;
	}

	/**
	 * Load the list of episodes for the specified show. If no episode names
	 * have been downloaded, we don't load any. We check for the existence of
	 * the files for each episode. If it exists, then we mark it in blue to show
	 * it has been downloaded. When done, we update the format label for the
	 * currently selected episode title.
	 */
	public void loadEpisodeList() {
		int iPoint = jlShows.getSelectedIndex(), x;
		// System.out.println("iPoint: " + iPoint + ", Length of Show Titles: "
		// + showTitles.length);
		if (iPoint < 0) {
			return;
		}
		String showTitle = showTitles[iPoint];
		String[] loadTitles;
		allEps.loadEpisodes(showTitle);
		epFiles = allEps.listSortedFiles();
		epTitles = allEps.listTitles(epFiles);
		loadTitles = new String[epTitles.length];
		for (x = 0; x < epTitles.length; x++) {
			if (allEps.isDownloaded(epFiles[x])) {
				loadTitles[x] = "<html><font color=blue>" + epTitles[x]
						+ "</font></html>";
			} else {
				loadTitles[x] = epTitles[x];
			}
		}
		jlEpisodes.setListData(loadTitles);
		if (loadTitles.length > 0) {
			if (iPoint >= loadTitles.length) {
				iPoint = loadTitles.length - 1;
			}
			jlEpisodes.setSelectedIndex(iPoint);
		}
		setEpisodeFormat();
		return;
	}

	/**
	 * Update the label to specify what audio format this file is in.
	 */
	public void setEpisodeFormat() {
		int iPoint = jlEpisodes.getSelectedIndex();
		String sFormat = "";
		if (iPoint >= 0 && epFiles.length >= iPoint + 1) {
			sFormat = allEps.getFormat(epFiles[iPoint]);
		}
		jFormatDataLabel.setText(sFormat);
		return;
	}

	/**
	 * Download the show titles. Call the main shell to download them, then when
	 * they're downloaded, sort them and save them to the hard drive.
	 */
	public void getShowTitles() {
		new Thread(new Runnable() {
			public void run() {
				// mainShell.downloadShowList();
				deactivate();
				webOps.downloadShowList();
				tagEditor.reload();
				titleControl.reload();
				activate();
				loadShowList();
			}
		}).start();
		return;
	}

	/**
	 * Download the episode titles. We find the show or page for a show that
	 * we're on and download all the titles for that episode. When we're done,
	 * be sure to load the list of episodes.
	 */
	public void getEpisodeTitles() {
		showMonitor.activate("Downloading requested episode titles...");
		new Thread(new Runnable() {
			public void run() {
				int x;
				int[] iList = jlShows.getSelectedIndices();
				showMonitor.setTaskLength(0, iList.length);
				for (x = 0; x < iList.length; x++) {
					// System.out.println("Getting episode titles for show: " +
					// showTitles[iList[x]]);
					webOps.downloadEpisodeList(showTitles[iList[x]]);
					showMonitor.updateProgressBar(x);
					if (showMonitor.isCancelled)
						break;
				}
				loadShowList();
				loadEpisodeList();
				showMonitor.deactivate();
			}
		}).start();
		return;
	}

	/**
	 * Add the selected episodes to the download queues
	 */
	public void addSelectedToQueue() {
		int x;
		int[] iList = jlEpisodes.getSelectedIndices();
		x = jlShows.getSelectedIndex();
		String showTitle = showTitles[x], epFile;
		for (x = 0; x < iList.length; x++) {
			epFile = epFiles[iList[x]];
			qDown.addItem(showTitle, epFile);
		}
		return;
	}

	/**
	 * Download actual episodes. The main shell class does most of the work for
	 * us. We go through all the episodes selected in the list and download
	 * them. When done, we reload the episode list so we can make sure it
	 * displays the newly downloaded episodes in blue.
	 */
	public void downloadEpisodes(boolean notLocal) {
		fromQueue = notLocal;
		showMonitor.activate("Downloading requested episode files.");
		fileMonitor.activate("Downloading file...");
		isAborted = false;
		String[] tempList = qDown.getQueue();
		System.out.println("Length of download Queue: " + tempList.length);
		deactivate();
		new Thread(new Runnable() {
			public void run() {
				// boolean isSuccess = true;
				int x, iTotal;
				int[] iList;
				String showName, epFile, webURL, localFile;
				String[] dlFiles, fileInfo;
				tagEditor.dlCount.resetAll();
				webOps.resetErrorQueue();
				// StringHashMap showTags = new StringHashMap();
				if (fromQueue) {
					dlFiles = qDown.getQueue();
					System.out.println("Length of download Queue: "
							+ dlFiles.length);
					showMonitor.setTaskLength(0, dlFiles.length);
					if (dlFiles.length > 5)
						askForAutomated();
					System.out.println("Have automated results for queue: "
							+ isAutomated);
					iTotal = dlFiles.length;
					for (x = 0; x < iTotal; x++) {
						showMonitor.setData("Downloading requested episode files.", "<html><center>Downloading file " + 
								(x + 1) + " of " + iTotal + "</center></html>");
						fileInfo = dlFiles[x].split("\t");
						showName = fileInfo[0];
						epFile = fileInfo[1];
						webURL = fileInfo[2];
						localFile = fileInfo[3];
						webOps.downloadAndTagFile(showName, epFile, localFile, webURL);
						showMonitor.updateProgressBar(x + 1);
						qDown.updateDownloadCount(x + 1);
						isAborted = showMonitor.isCancelled;
						if (isAborted) {
							break;
						}
					}
				} else {
					iList = jlEpisodes.getSelectedIndices();
					showMonitor.setTaskLength(0, iList.length);
					if (iList.length > 5)
						askForAutomated();
//					System.out.println("Have automated results for lists: " + isAutomated);
					iTotal = iList.length;
					for (x = 0; x < iTotal; x++) {
						showMonitor.setData("Downloading requested episode files.", "<html><center>Downloading file " + 
								(x + 1) + " of " + iTotal + "</center></html>");
						// System.out.println("Downloading file #" + x + ",
						// episode from show: " + showTitle + ", Name: " +
						// epTitle);
						epFile = epFiles[iList[x]];
						showName = allEps.getShow(epFile);
						webURL = allEps.getURL(epFile);
						localFile = allEps.getFilePath(epFile);
						webOps.downloadAndTagFile(showName, epFile, localFile,
								webURL);
						showMonitor.updateProgressBar(x + 1);
						isAborted = showMonitor.isCancelled;
						if (isAborted) {
							break;
						}
					}
				}
				// String epFile, epTitle, showTitle;
				loadEpisodeList();
				showMonitor.deactivate();
				fileMonitor.deactivate();
				if (isAborted) {
					guiUtils.setParentFrame(jFrame);
					guiUtils.showInfoDialog("Downloading files aborted.");
				}
				isAborted = false;
				String[] allErrors = webOps.getErrorQueue();
				if (allErrors.length > 0) {
					errorList.reset();
					errorList.addItems(allErrors);
					errorList.setVisible(true);
				}
				activate();
			}
		}).start();
		return;
	}

	/**
	 * Check and see if we should run in automated mode. Sometimes there is a
	 * lot to download and asking questions may block several hours of work the
	 * user wanted done while away from the computer.
	 * 
	 * @return true if we go into automated mode
	 */
	public boolean askForAutomated() {
		String sPrompt = "This may take a while.  Do you want this done on automatic mode?\n"
				+ "(Automatic mode means you are not notified of errors until the end.)";
		guiUtils.setParentFrame(jFrame);
		isAutomated = guiUtils.showYesNoDialog(sPrompt);
		return isAutomated;
	}

	/**
	 * Make the GUI visible or invisible
	 * 
	 * @param setVisible
	 *            determine if the window is visible or not
	 */
	public void setVisible(boolean setVisible) {
		isVisible = setVisible;
		jFrame.setVisible(isVisible);
		return;
	}

	/**
	 * Set the show description to match the show selected.
	 */
	public void setShowDesc() {
		int iPoint = jlShows.getSelectedIndex();
		if (iPoint >= 0 && iPoint < showDesc.length) {
			jtShowDesc.setText(showDesc[iPoint]);
		}
		return;
	}

	public void setDLDir() {
		deactivate();
		String dirName = "";
		guiUtils.setParentFrame(jFrame);
		dirName = guiUtils
				.showDirectoryDialog("Find and select your download directory.");
		if (!dirName.equals("")) {
			myConfig.set("DownloadDirectory", dirName);
			myConfig.saveConfigFile();
		}
		activate();
		return;
	}

	/**
	 * Deactivate all the controls on this control panel.
	 */
	public void deactivate() {
		setActive(false);
		qDown.deactivate();
		return;
	}

	/**
	 * Activate all the controls on this control panel.
	 */
	public void activate() {
		setActive(true);
		qDown.activate();
		return;
	}

	/**
	 * Deactivate or Activate all the controls on this control panel. Set
	 * enabled state on each component to whatever isActive is
	 * 
	 * @param true
	 *            to make components active, false for inactive
	 */
	private void setActive(boolean isActive) {
		jScrollPane.setEnabled(isActive);
		jScrollPane1.setEnabled(isActive);
		jScrollPane2.setEnabled(isActive);
		jbGetShows.setEnabled(isActive);
		jbGetEpisodes.setEnabled(isActive);
		jbGetEpisodes2.setEnabled(isActive);
		jbEditTags.setEnabled(isActive);
		jbTitles.setEnabled(isActive);
		jbAddQueue.setEnabled(isActive);
		jbEditQueue.setEnabled(isActive);
		jbDLQueue.setEnabled(isActive);
		jbDownload.setEnabled(isActive);
		jbAbout.setEnabled(isActive);
		jbHelp.setEnabled(isActive);
		// jbQuit.setEnabled(isActive);
		jbNewDir.setEnabled(isActive);
		jlShows.setEnabled(isActive);
		jlEpisodes.setEnabled(isActive);
		jtShowDesc.setEnabled(isActive);
		return;
	}

	/**
	 * Handle all the actions for the button. Dispatch threads and/or
	 * subroutines to get show or episode lists or to download episode files.
	 */
	public void actionPerformed(ActionEvent aEvent) {
		Object sourceControl = aEvent.getSource();
		if (sourceControl == jbGetShows) {
			getShowTitles();
			loadEpisodeList();
		} else if (sourceControl == jbGetEpisodes || sourceControl == jbGetEpisodes2) {
			getEpisodeTitles();
		} else if (sourceControl == jbAbout) {
			if (firstAbout)
				aboutWindow.centerOnWindow(jFrame);
			firstAbout = false;
			aboutWindow.setVisible(true);
		} else if (sourceControl == jbHelp) {
			if (firstHelp)
				helpWindow.centerOnWindow(jFrame);
			firstHelp = false;
			helpWindow.setVisible(true);
		} else if (sourceControl == jbAddQueue) {
			this.addSelectedToQueue();
		} else if (sourceControl == jbEditQueue) {
			qDown.setVisible(true);
		} else if (sourceControl == jbDLQueue) {
			downloadEpisodes(true);
		} else if (sourceControl == jbEditTags) {
			tagEditor.setVisible(true);
		} else if (sourceControl == jbTitles) {
			titleControl.setVisible(true);
		} else if (sourceControl == jbDownload) {
			downloadEpisodes(false);
		} else if (sourceControl == jbNewDir) {
			setDLDir();
		} else if (sourceControl == jbQuit) {
			System.exit(0);
		}
		return;
	}

	/**
	 * Handle the list change events. Basically change what changes when the
	 * selected item changes. In the show list, when it changes we have to load
	 * in a new episode list. When a new episode is selected, we update the file
	 * audio format label. We track what the last selected item is to make sure
	 * we don't get a double-selection and do it twice.
	 */
	public void valueChanged(ListSelectionEvent lsEvent) {
		JList jlSource = (JList) lsEvent.getSource();
		int thisIndex = jlSource.getSelectedIndex();
		if (jlSource == jlShows) {
			if (lastShow == thisIndex) {
				return;
			}
			loadEpisodeList();
			setShowDesc();
			lastShow = thisIndex;
		} else if (jlSource == jlEpisodes) {
			if (lastEpisode == thisIndex) {
				return;
			}
			setEpisodeFormat();
			lastEpisode = thisIndex;
		}
		return;
	}

	/**
	 * Extra GUI setup stuff. Keep this stuff isolated from actual programming
	 * work.
	 */
	private void guiSetup() {
		getJFrame();
		GUIUtils.centerWindow(jFrame);
		jFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		jScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		jScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		jScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		jScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		jScrollPane2.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		jScrollPane2.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		jlShows.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		jlEpisodes.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		jlShows.addListSelectionListener(this);
		jlEpisodes.addListSelectionListener(this);
		jtShowDesc.setLineWrap(true);
		jtShowDesc.setWrapStyleWord(true);
		jbGetShows.addActionListener(this);
		jbGetEpisodes.addActionListener(this);
		jbGetEpisodes2.addActionListener(this);
		jbAddQueue.addActionListener(this);
		jbDLQueue.addActionListener(this);
		jbEditQueue.addActionListener(this);
		jbEditTags.addActionListener(this);
		jbTitles.addActionListener(this);
		jbDownload.addActionListener(this);
		jbNewDir.addActionListener(this);
		jbAbout.addActionListener(this);
		jbHelp.addActionListener(this);
		jbQuit.addActionListener(this);
		return;
	}

	// =============================================================================
	// Beyond here, there be dragons
	// =============================================================================

	/**
	 * This method initializes jFrame
	 * 
	 * @return javax.swing.JFrame
	 */
	private JFrame getJFrame() {
		if (jFrame == null) {
			jFrame = new JFrame();
			jFrame.setSize(new Dimension(668, 536));
			jFrame.setTitle("Old Time Radio Show Downloader");
			jFrame.setContentPane(getJContentPane());
		}
		return jFrame;
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
			gridBagConstraints10.gridx = 0;
			gridBagConstraints10.gridy = 2;
			GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
			gridBagConstraints31.gridx = 0;
			gridBagConstraints31.gridy = 2;
			GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
			gridBagConstraints11.gridx = 1;
			gridBagConstraints11.gridy = 0;
			jLabel1 = new JLabel();
			jLabel1.setText("Show Description:");
			GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
			gridBagConstraints9.insets = new Insets(12, 12, 5, 5);
			gridBagConstraints9.gridy = 0;
			gridBagConstraints9.ipadx = 266;
			gridBagConstraints9.ipady = 10;
			gridBagConstraints9.gridx = 0;
			GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
			gridBagConstraints8.insets = new Insets(6, 5, 12, 11);
			gridBagConstraints8.gridy = 7;
			gridBagConstraints8.ipadx = 94;
			gridBagConstraints8.gridx = 1;
			GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
			gridBagConstraints7.insets = new Insets(7, 5, 3, 11);
			gridBagConstraints7.gridy = 5;
			gridBagConstraints7.ipadx = 75;
			gridBagConstraints7.ipady = 55;
			gridBagConstraints7.gridx = 1;
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.insets = new Insets(6, 12, 12, 6);
			gridBagConstraints6.gridy = 4;
			gridBagConstraints6.ipadx = 50;
			gridBagConstraints6.gridx = 1;
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.insets = new Insets(4, 12, 5, 6);
			gridBagConstraints5.gridy = 7;
			gridBagConstraints5.ipadx = 48;
			gridBagConstraints5.ipady = 4;
			gridBagConstraints5.gridx = 0;
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.insets = new Insets(5, 12, 4, 6);
			gridBagConstraints4.gridy = 3;
			gridBagConstraints4.ipadx = 198;
			gridBagConstraints4.ipady = 12;
			gridBagConstraints4.gridx = 0;
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.fill = GridBagConstraints.BOTH;
			gridBagConstraints3.gridx = 1;
			gridBagConstraints3.gridy = 1;
			gridBagConstraints3.ipadx = 214;
			gridBagConstraints3.ipady = 127;
			gridBagConstraints3.weightx = 1.0;
			gridBagConstraints3.weighty = 1.0;
			gridBagConstraints3.gridheight = 2;
			gridBagConstraints3.insets = new Insets(6, 5, 5, 11);
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.fill = GridBagConstraints.BOTH;
			gridBagConstraints2.gridx = 0;
			gridBagConstraints2.gridy = 4;
			gridBagConstraints2.ipadx = 151;
			gridBagConstraints2.ipady = 12;
			gridBagConstraints2.weightx = 1.0;
			gridBagConstraints2.weighty = 1.0;
			gridBagConstraints2.gridheight = 2;
			gridBagConstraints2.insets = new Insets(5, 12, 7, 5);
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 1;
			gridBagConstraints1.ipadx = 150;
			gridBagConstraints1.ipady = 14;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.weighty = 1.0;
			gridBagConstraints1.insets = new Insets(6, 12, 5, 6);
			jFormatDataLabel = new JLabel();
			jFormatDataLabel.setText("64 kps MP3");
			jFormatLabel = new JLabel();
			jFormatLabel.setText("Format: ");
			jEpisodeLabel = new JLabel();
			jEpisodeLabel.setText("Episode Titles:");
			jShowLabel = new JLabel();
			jShowLabel.setText("Available Radio Shows:");
			jContentPane = new JPanel();
			jContentPane.setLayout(new GridBagLayout());
			jContentPane.add(getJScrollPane(), gridBagConstraints1);
			jContentPane.add(getJScrollPane1(), gridBagConstraints2);
			jContentPane.add(getJScrollPane2(), gridBagConstraints3);
			jContentPane.add(getJPanel(), gridBagConstraints4);
			jContentPane.add(getJPanel1(), gridBagConstraints5);
			jContentPane.add(getJPanel3(), gridBagConstraints6);
			jContentPane.add(getJPanel4(), gridBagConstraints7);
			jContentPane.add(getJPanel5(), gridBagConstraints8);
			jContentPane.add(getJPanel6(), gridBagConstraints9);
			jContentPane.add(jLabel1, gridBagConstraints11);
			jContentPane.add(getJPanel2(), gridBagConstraints31);
			jContentPane.add(getJPanel8(), gridBagConstraints10);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jbTitles
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJbTitles() {
		if (jbTitles == null) {
			jbTitles = new JButton();
			jbTitles.setText("Title Filters");
			jbTitles.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jbTitles;
	}

	/**
	 * This method initializes jPanel
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			jPanel = new JPanel();
			jPanel.setLayout(new BoxLayout(getJPanel(), BoxLayout.X_AXIS));
			jPanel.add(jEpisodeLabel, null);
			jPanel.add(Box.createHorizontalGlue());
			jPanel.add(jFormatLabel, null);
			jPanel.add(jFormatDataLabel, null);
		}
		return jPanel;
	}

	/**
	 * This method initializes jPanel1
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel1() {
		if (jPanel1 == null) {
			jPanel1 = new JPanel();
			jPanel1.setLayout(new BoxLayout(getJPanel1(), BoxLayout.X_AXIS));
			jPanel1.add(Box.createHorizontalGlue());
			jPanel1.add(getJbGetEpisodes(), null);
			jPanel1.add(Box.createHorizontalGlue());
			jPanel1.add(getJbDownload(), null);
			jPanel1.add(Box.createHorizontalGlue());
		}
		return jPanel1;
	}

	/**
	 * This method initializes jPanel3
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel3() {
		if (jPanel3 == null) {
			jPanel3 = new JPanel();
			jPanel3.setLayout(new BoxLayout(getJPanel3(), BoxLayout.X_AXIS));
			jPanel3.add(Box.createGlue());
			jPanel3.add(getJbAddQueue(), null);
			jPanel3.add(Box.createGlue());
			jPanel3.add(getJbEditQueue(), null);
			jPanel3.add(Box.createGlue());
			jPanel3.add(getJbDLQueue(), null);
			jPanel3.add(Box.createGlue());
			Border loweredEtched = BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
			TitledBorder tBorder = BorderFactory.createTitledBorder(loweredEtched, "Download Queue:");
			tBorder.setTitleJustification(TitledBorder.DEFAULT_JUSTIFICATION);
			tBorder.setTitlePosition(TitledBorder.DEFAULT_POSITION);
			jPanel3.setBorder(tBorder);
		}
		return jPanel3;
	}

	/**
	 * This method initializes jPanel4
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel4() {
		if (jPanel4 == null) {
			jPanel4 = new JPanel();
			jPanel4.setLayout(new BoxLayout(getJPanel4(), BoxLayout.Y_AXIS));
			jPanel4.add(Box.createGlue());
			jPanel4.add(getJPanel7(), null);
//			jPanel4.add(jLabel, null);
//			jPanel4.add(Box.createGlue());
			jPanel4.add(Box.createGlue());
			jPanel4.add(getJbNewDir(), null);
			jPanel4.add(Box.createGlue());
			Border loweredEtched = BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
			TitledBorder tBorder = BorderFactory.createTitledBorder(loweredEtched, "Advanced Features:");
			tBorder.setTitleJustification(TitledBorder.DEFAULT_JUSTIFICATION);
			tBorder.setTitlePosition(TitledBorder.DEFAULT_POSITION);
			jPanel4.setBorder(tBorder);
		}
		return jPanel4;
	}

	/**
	 * This method initializes jPanel5
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel5() {
		if (jPanel5 == null) {
			jPanel5 = new JPanel();
			jPanel5.setLayout(new BoxLayout(getJPanel5(), BoxLayout.X_AXIS));
			jPanel5.add(Box.createHorizontalGlue());
			jPanel5.add(getJbAbout(), null);
			jPanel5.add(Box.createHorizontalGlue());
			jPanel5.add(getJbHelp(), null);
			jPanel5.add(Box.createHorizontalGlue());
			jPanel5.add(getJbQuit(), null);
			jPanel5.add(Box.createHorizontalGlue());
		}
		return jPanel5;
	}

	/**
	 * This method initializes jPanel6
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel6() {
		if (jPanel6 == null) {
			jPanel6 = new JPanel();
			jPanel6.setLayout(new BoxLayout(getJPanel6(), BoxLayout.X_AXIS));
			jPanel6.add(Box.createHorizontalGlue());
			jPanel6.add(jShowLabel, null);
			jPanel6.add(Box.createHorizontalGlue());
		}
		return jPanel6;
	}

	/**
	 * This method initializes jbGetShows
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJbGetShows() {
		if (jbGetShows == null) {
			jbGetShows = new JButton();
			jbGetShows.setText("Get Show List");
		}
		return jbGetShows;
	}

	/**
	 * This method initializes jtShowDesc
	 * 
	 * @return javax.swing.JTextArea
	 */
	private JTextArea getJtShowDesc() {
		if (jtShowDesc == null) {
			jtShowDesc = new JTextArea();
		}
		return jtShowDesc;
	}

	/**
	 * This method initializes jbGetEpisodes
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJbGetEpisodes() {
		if (jbGetEpisodes == null) {
			jbGetEpisodes = new JButton();
			jbGetEpisodes.setText("Get Episodes");
		}
		return jbGetEpisodes;
	}

	/**
	 * This method initializes jbDownload
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJbDownload() {
		if (jbDownload == null) {
			jbDownload = new JButton();
			jbDownload.setText("Download Files");
		}
		return jbDownload;
	}

	/**
	 * This method initializes jbHelp
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJbHelp() {
		if (jbHelp == null) {
			jbHelp = new JButton();
			jbHelp.setText("Help");
			jbHelp.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jbHelp;
	}

	/**
	 * This method initializes jScrollPane
	 * 
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setViewportView(getJList());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jScrollPane1
	 * 
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getJScrollPane1() {
		if (jScrollPane1 == null) {
			jScrollPane1 = new JScrollPane();
			jScrollPane1.setViewportView(getJList1());
		}
		return jScrollPane1;
	}

	/**
	 * This method initializes jList
	 * 
	 * @return javax.swing.JList
	 */
	private JList getJList() {
		if (jlShows == null) {
			jlShows = new JList();
		}
		return jlShows;
	}

	/**
	 * This method initializes jList1
	 * 
	 * @return javax.swing.JList
	 */
	private JList getJList1() {
		if (jlEpisodes == null) {
			jlEpisodes = new JList();
		}
		return jlEpisodes;
	}

	/**
	 * This method initializes jScrollPane2
	 * 
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getJScrollPane2() {
		if (jScrollPane2 == null) {
			jScrollPane2 = new JScrollPane();
			jScrollPane2.setViewportView(getJtShowDesc());
		}
		return jScrollPane2;
	}

	/**
	 * This method initializes jbQuit
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJbQuit() {
		if (jbQuit == null) {
			jbQuit = new JButton();
			jbQuit.setText("Quit");
			jbQuit.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jbQuit;
	}

	/**
	 * This method initializes jbNewDir
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJbNewDir() {
		if (jbNewDir == null) {
			jbNewDir = new JButton();
			jbNewDir.setText("Change Directory");
			jbNewDir.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jbNewDir;
	}

	/**
	 * This method initializes jbAddQueue
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJbAddQueue() {
		if (jbAddQueue == null) {
			jbAddQueue = new JButton();
			jbAddQueue.setText("Add Files");
		}
		return jbAddQueue;
	}

	/**
	 * This method initializes jbEditQueue
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJbEditQueue() {
		if (jbEditQueue == null) {
			jbEditQueue = new JButton();
			jbEditQueue.setText("Edit");
		}
		return jbEditQueue;
	}

	/**
	 * This method initializes jbDLQueue
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJbDLQueue() {
		if (jbDLQueue == null) {
			jbDLQueue = new JButton();
			jbDLQueue.setText("Download");
		}
		return jbDLQueue;
	}

	/**
	 * This method initializes jbEditTags
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJbEditTags() {
		if (jbEditTags == null) {
			jbEditTags = new JButton();
			jbEditTags.setText("Tag Editor");
			jbEditTags.setAlignmentX(Component.CENTER_ALIGNMENT);
		}
		return jbEditTags;
	}
	/**
	 * This method initializes jbAbout	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbAbout() {
		if (jbAbout == null) {
			jbAbout = new JButton();
			jbAbout.setText("About");
		}
		return jbAbout;
	}

	/**
	 * This method initializes jPanel2	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel2() {
		if (jPanel2 == null) {
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.insets = new Insets(6, 12, 4, 294);
			gridBagConstraints.gridy = 0;
			gridBagConstraints.ipadx = 21;
			gridBagConstraints.gridx = 0;
			jPanel2 = new JPanel();
			jPanel2.setLayout(new BoxLayout(getJPanel2(), BoxLayout.X_AXIS));
		}
		return jPanel2;
	}
	/**
	 * This method initializes jPanel7	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel7() {
		if (jPanel7 == null) {
			jPanel7 = new JPanel();
			jPanel7.setLayout(new BoxLayout(getJPanel7(), BoxLayout.X_AXIS));
			jPanel7.add(getJbEditTags(), null);
			jPanel7.add(getJbTitles(), null);
		}
		return jPanel7;
	}

	/**
	 * This method initializes jPanel8	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel8() {
		if (jPanel8 == null) {
			jPanel8 = new JPanel();
			jPanel8.setLayout(new BoxLayout(getJPanel8(), BoxLayout.X_AXIS));
			jPanel8.add(Box.createHorizontalGlue());
			jPanel8.add(getJbGetShows(), null);
			jPanel8.add(Box.createHorizontalGlue());
			jPanel8.add(getJBEps2(), null);
			jPanel8.add(Box.createHorizontalGlue());
		}
		return jPanel8;
	}

	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJBEps2() {
		if (jbGetEpisodes2 == null) {
			jbGetEpisodes2 = new JButton();
			jbGetEpisodes2.setText("Get Episodes");
		}
		return jbGetEpisodes2;
	}

} // @jve:decl-index=0:visual-constraint="42,55"
