package com.hal.util;
/**
Class  : TNUtil
Author : Hal Vaughan
Company: Threshold Digital, Ltd.
			4221 Wakefield Rd.
			Richmond, VA 23235
			(804)-560-2820
			thresholddigital.com
			hal@thresholddigital

	This is a set of utilities for general java programming.  It is
	licensed to Threshold Creative, and any companies
	owned by Threshold Creative for all types of use.  It is licensed
	to all others under the Gnu Public License.

	String[] splitLine(String Line): (overload of below -- assumes split on tab)
	String[] splitLine(String Line, String Token): Split a line into an array.  Look
	for the token and use it to split each field.  Very close to split() in Perl.

	String[] sortArray(String[] Array): Sort an array in ascending order.
*/

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.imageio.ImageIO;

/**
 * Just a set of various methods that help with small tasks along the way.  All methods
 * are static.
 * @author Hal
 *
 */
public class HalUtil {
	
	/**
	 * Just an easy way to sleep without having to remember to catch exceptions.
	 * @param iCount the milliseconds to sleep
	 */
	public static void sleep(int iCount) {
		try {Thread.sleep(iCount);} catch (Exception e) {}
		return;
	}
	
	/**
	 * A <i>simple</i> HTML stripper.  All it does is strip out the obvious, which is
	 * anything between a greater or less than sign.
	 * @param fullString String to strip
	 * @return string with HTML stripped out of it
	 */
	public static String stripSimpleHTML(String fullString) {
		int iStart, iEnd;
		String sOut = fullString;
		while (true) {
			iStart = sOut.indexOf("<");
			if (iStart >= 0) {
				iEnd = sOut.indexOf(">");
				if (iEnd <= iStart)
					break;
				if (iStart > 0)
					sOut = sOut.substring(0, iStart) + sOut.substring(iEnd + 1);
				else
					sOut = sOut.substring(iStart + iEnd + 1);
				
			} else {
				break;
			}
		}
		return sOut;
	}
	
	/**
	 * Do the regex work.
	 * @param sTarget target string to search and to modify
	 * @param sRegex the string that will be searched for
	 * @param sReplace the replacement value
	 * @return the new and replaced string
	 */
	public static String doRegex(String sTarget, String sRegex, String sReplace) {
		String newTitle = "";
		Pattern pRegex = Pattern.compile(sRegex);
		Matcher mRegex = pRegex.matcher(sTarget);
		newTitle = mRegex.replaceAll(sReplace);	
		return newTitle;
	}
	
	/**
	 * Join an array of strings, separating each one with the join expression
	 * @param inputArray array to join together
	 * @param joinString character or characters (or none) to separate all joined strings
	 * @return full string of all array values joined together
	 */
	public static String joinStrings(String[] inputArray, String joinString) {
		String fullString = "";
		for (int x = 0; x < inputArray.length; x++) {
			fullString = fullString + inputArray[x] + joinString;
		}
		fullString = fullString.substring(0, fullString.length() - joinString.length());
		return fullString;
	}

	/**
	 * Get an object of the class name we specify.  Call with the nae of a class and
	 * it returns an object of the type needed.  Remember to CAST the object to the
	 * needed type!
	 */
	static Object getObject(String className) {
		Object object = null;
		try {
			Class classDefinition = Class.forName(className);
			object = classDefinition.newInstance();
		} catch (Exception e) {
				System.out.println("Error w/ constructor. Class: " + className + ", Error: " + e);}
		return object;
	}

	/**
	 * Get an object of the class name we specify.  Call with the nae of a class and
	 * an array of objects to use as parameters and it returns an object of the type 
	 * needed.  Remember to CAST the object to the needed type!
	 */
	static Object getObject(String className, Object[] args) {
		Object object = null;
		Class classDefinition = null;
		Constructor classConstructor = null;
		Class[] argTypes = new Class[args.length];
		for (int i = 0; i < args.length; i++) {
			argTypes[i] = args[i].getClass();
		}
		try {
			classDefinition = Class.forName(className);
			classConstructor = classDefinition.getConstructor(argTypes);
			object = classConstructor.newInstance(args);
		} catch (Exception e) {
				System.out.println("Error w/ constructor[]. Class: " + className + ", Error: " + e);}
		return object;
	}

	static Object callMethod(String sMethod, Object oClass, Object[] oParm) {
		Class classDefinition = oClass.getClass();
		Object o = null;
		Class[] cParm = null;
		if (!(oParm == null)) {
			cParm = new Class[oParm.length];
			for (int i = 0; i < oParm.length; i++) {
				cParm[i] = oParm[i].getClass();
			}
		}
		try {
			Method cMethod = classDefinition.getMethod(sMethod, cParm);
			o = cMethod.invoke(oClass, oParm);
		} catch (Exception e) {
				System.out.println("Error w/ Method.  Method: " + sMethod + ", Error: " + e);}
		return o;
	}

	/**
	 * Kill the quotes (single or double) at the start ane end of a line
	 * @param sLine the line to remove quotes from
	 * @return the same line given without quotes.
	 */
	public static String killQuotes(String sLine) {
		if (sLine.startsWith("\"") && sLine.endsWith("\"")) {
			sLine = sLine.substring(1, sLine.length() - 1);
		}
		if (sLine.startsWith("'") && sLine.endsWith("'")) {
			sLine = sLine.substring(1, sLine.length() - 1);
		}
		return sLine;
	}

	/**
	 * Get a screenshot and save it to the default filename of Screenshot.png.
	 * Overloaded version with a generic name instead of specifying a file name.
	 */
	public static void getScreenshot() {
		getScreenshot("Screenshot");
		return;
	}

	/**
	 * Get a screenshot and save it as a png file to the filename specified.
	 * @param sName The filename to save the screenshot to.
	 */
	public static void getScreenshot(String sName) {
		Dimension dSize = Toolkit.getDefaultToolkit().getScreenSize();
		Rectangle rSize = new Rectangle(0, 0, dSize.width, dSize.height);
		try {
			Robot oRobot = new Robot();
			BufferedImage image = oRobot.createScreenCapture(rSize);
			File fFile = new File(sName + ".png");
			ImageIO.write(image, "png", fFile);
		} catch (Exception e) {
			System.out.println("Exception caught: " + e);
			e.printStackTrace();
		}
		return;
	}
	
	/**
	 * Take tall the keys from a HashMap and convert them to a sorted array.
	 * @param inList The HashMap to get the keys from
	 * @return the sorted list of keys
	 */
	public static String[] hashKeysToArray(HashMap inList) {
		String[] varList = new String[inList.size()];
		varList = (String[]) inList.keySet().toArray(varList);
		Arrays.sort(varList);
		return varList;
	}

}
